//AIM:Compute the absorption loss taking place in an optical fiber
//Software version Scilab 5.5.2
//OS Windows 7
clc;
clear;
//Let the length of the optical fiber be 3.5cm in an interference sphere,while 
//the total length of the fiber be 1km.
//Also consider that it gives 5.1nV & 165 micro Volts corresponding to 
//scattered & unscattered light respectively while for the cutback method,
//it gives 5.20V & 22V for original & cutback optical fibers respectively.

l=3.5*(10^(-5));//l=Length of optical in integrating sphere
Vsc=5.1*(10^(-9));//Vsc=Voltage level corresponding to scattered light
Vop=165*(10^(-6));//Vop=Voltage level corresponding to unscattered light
//Computing the scattering loss :
alpha_sc=(4.343/l)*(Vsc/Vop);
disp('dB/km',alpha_sc,'Scattering loss (alpha_sc)=')
//Computation of total attenuation:
L1=1;//L1=Length of the original fiber
L2=0.002;//L2=Length of cutback optical fiber
V2=22;//V2=Voltage level for cutback optical fiber
V1=5.20;//V1=Voltage level for original optical fiber
alpha_T=(1/(L1-L2))*(10*log10(V2/V1));//alpha_T=total attenuation
disp('dB/km',alpha_T,'Total attenuation (alpha_T) =')
//Computing the absorption loss :
AL=alpha_T-alpha_sc;//AL=Absorption loss
disp('dB/km',AL,'Absorption loss=')
